#!/bin/bash
zenity --info  --width=250 --height=100 --window-icon="info" --title "Nuevo Script" --text "Creación de carpeta, cambio de permisos y visualización" 

carpeta=$(zenity --entry  --width=250 --height=100 --title "Nueva carpeta" --text "Introduce el nombre de la nueva carpeta")

mkdir $carpeta

listado=$(ls -la)

zenity --info  --width=250 --height=400 --window-icon="info" --title "Permisos" --text "$listado" 

permiso=$(zenity --entry  --width=250 --height=100 --title "Nuevos permisos" --text "Introduce los nuevos permisos:")

chmod -R $permiso $carpeta


listado=$(ls -la)

zenity --info  --width=250 --height=400 --window-icon="info" --title "Nuevos permisos" --text "$listado" 

respuesta=$(zenity --question  --width=250 --height=100 --title "Borrado de carpeta" --text "¿Quieres borrar la carpeta?")


case $respuesta in
	S|s)
		zenity --info  --width=250 --height=400 --window-icon="info" --title "Borrado" --text "Voy a borrar la carpeta" 
		rm -rf $carpeta
		zenity --info  --width=250 --height=400 --window-icon="info" --title "Borrado" --text "Aquí verás que ya no está"
		
		listado=$(ls -la)
		zenity --info  --width=250 --height=400 --window-icon="info" --title "Nuevos permisos" --text "$listado" 
		;;
	N|n)
		zenity --info  --width=250 --height=400 --window-icon="info" --title "Borrado" --text "No he borrado nada"
		
		listado=$(ls -la)
		zenity --info  --width=250 --height=400 --window-icon="info" --title "Nuevos permisos" --text "$listado" 
		;;

	*)
		zenity --info  --width=250 --height=400 --window-icon="info" --title "Valor invalido" --text "El valor introducido no es correcto"
		;;
esac
